﻿using System;
using Soneta.Types;
using Soneta.Business;
using Soneta.Ksiega;
using System.Web.UI.WebControls;
using Soneta.Web;
using System.Web;

namespace ASP
{
    public partial class ZestawienieKsiegowePKB : System.Web.UI.Page
    {
        public static string Exc_NieWybranoZestawienia = "Nie zaznaczono zestawienia.";
        public static string Str_Numer = "Numer";
        public static string Str_Opis = "Opis";
        public static string Str_Wartosc = "Wartość";

        protected void ZestawienieKsiegowe_OnLoad(Object sender, EventArgs args)
        {
            if (!DataContext1.Context.Contains(typeof (WynikZestKS)))        
                throw new BusException(Exc_NieWybranoZestawienia);
            WynikZestKS w = (WynikZestKS) DataContext1.Get(typeof(WynikZestKS));
            ZestawienieKS z = w.Zestawienie;
            ZestawieniaKS.Params p = new ZestawieniaKS.Params(DataContext1.Context);
            if (DataContext1.Context.Contains(typeof (ZestawieniaKS.Params)))
                p = (ZestawieniaKS.Params) DataContext1.Get(typeof (ZestawieniaKS.Params));

            DataContext1.Landscape = false;
            cc = ColumnsCreator.Init(w, p, param);
            ReportHeader1.Title = encode(cc.Title);
            cc.Landscape = DataContext1.Landscape;
            cc.Grid = Grid1;
        }

        ColumnsCreator cc = null;

        class ColumnsCreator {
            readonly ZestawienieKS.Wynik Wynik;
            public bool Landscape = false;
            readonly Params param;

            public ColumnsCreator(ZestawienieKS.Wynik wynik, Params param) {
                this.Wynik = wynik;
                this.param = param;
            }

            static public ColumnsCreator Init(WynikZestKS wynik, ZestawieniaKS.Params param, Params printParam) {
                return new ColumnsCreator(ZestawienieKS.Wynik.Deserialize(wynik), printParam);
            }

            public string Title {
                get { return Wynik.Tytul; }
            }

            static int szeroki = 8;
            static int waski = 4;

            void initColumns() {
                int iloscKolumnZest = Wynik.Kolumny.Length;
                int maxIloscKolumn = (Landscape) ? szeroki : waski;
                if (iloscKolumnZest > 0)
                    grid.RowsInRow = (int)Math.Ceiling((double)iloscKolumnZest / maxIloscKolumn);
                int iloscKolumn = (int)Math.Ceiling((double)iloscKolumnZest / grid.RowsInRow);
                int iloscKomorek = iloscKolumn * grid.RowsInRow;

                GridColumn col = null;
                col = new GridColumn();
                col.Caption = Str_Numer;
                col.Width = 12;
                col.RowSpan = grid.RowsInRow;
                grid.Columns.Add(col);


                col = new GridColumn();
                col.Caption = Str_Opis;
                col.RowSpan = grid.RowsInRow;
                grid.Columns.Add(col);

                foreach (ZestawienieKS.Wynik.Kolumna kol in Wynik.Kolumny) {
                    col = new GridColumn();
                    col.Caption = kol.Tytul;
                    if(iloscKolumn>(maxIloscKolumn/2))
                        col.Width = 16;
                    else
                        col.Width = 25;
                    col.Format = "{0:n}";
                    col.Align = HorizontalAlign.Right;
                    grid.Columns.Add(col);
                    iloscKomorek--;
                }

                while (iloscKomorek > 0) {
                    col = new GridColumn();
                    col.Caption = "";
                    grid.Columns.Add(col);
                    iloscKomorek--;
                }

                grid.DataSource = Wynik.Pozycje;
            }

            public Grid Grid {
                get {
                    return grid;
                }
                set {
                    detachGrid();
                    grid = value;
                    attachGrid();
                    initColumns();
                }
            }

            void attachGrid() {
                if (grid == null)
                    return;
                grid.BeforeRow += new RowEventHandler(OnBeforeRow);
            }
            void detachGrid() {
                if (grid == null)
                    return;
                grid.BeforeRow -= new RowEventHandler(OnBeforeRow);
            }

            Grid grid = null;

            protected void OnBeforeRow(object sender, Soneta.Web.RowEventArgs args) {
                ZestawienieKS.Pozycja poz = (ZestawienieKS.Pozycja)args.Row;
                PozycjaZestKS p = (PozycjaZestKS)KsiegaModule.GetInstance(poz.Wynik.Zestawienie).PozycjeZestKS.WgZestawienie[poz.Wynik.Zestawienie, poz.Symbol].GetPrev();
                string format = "{0}";
                if (p != null && p.PozycjaNadrzedna == null)
                    format = "<B>{0}</B>";
                grid.Columns[0].EditValue = string.Format(format,numerOstatniSegment(encode(poz.Numer)));
                grid.Columns[1].EditValue = string.Format(format,encode(poz.Opis).Replace(" ", "&nbsp;"));

                format = format.Replace("{0}", "{0:n}");
                for (int i = 0; i < poz.Komorki.Count; i++) {
                    if (param.PokazInfoSkrocone && poz[i].InfoSkrocone != "Brak") {
                        grid.Columns[i + 2].Align = HorizontalAlign.Left;
                        string s = "";
                        string[] sa = poz[i].InfoSkrocone.Split(';');
                        for (int j = 0; j < sa.Length; j++)
                            s += sa[j].Trim() + (j < sa.Length - 1 ? "\n" : "");
                        grid.Columns[i + 2].EditValue =
                            string.Format(Str_Wartosc + ": {0}\n{1}", string.Format(format, poz[i].Wartosc), s);
                    } else {
                        grid.Columns[i + 2].Align = HorizontalAlign.Right;
                        grid.Columns[i + 2].EditValue = param.UkrywajZera && poz[i].Wartosc == 0m ? "&nbsp;" : String.Format(format, poz[i].Wartosc) ;
                    }
                }
            }




            string numerOstatniSegment(string numer) {
                if (!param.TylkoOstatniSegmentNumeru)
                    return numer;
                int i = numer.LastIndexOf(".");
                if (i < 0)
                    return numer;
                int j = i+1;
                string s = "";
                while (j > 0) {
                    s += "&nbsp;";
                    j--;
                }
                return s + numer.Substring(i+1);
            }

        }


        public static String encode(String s)
        {
            return System.Web.HttpUtility.HtmlEncode(s);
        }


        Params param = null;
        [Context]
        public Params Param {
            get { return param; }
            set { param = value; }
        }

        public class Params : ContextBase {
            public Params(Context cx)
              : base(cx) { }

            bool tylkoOstatniSegmentNumeru = false;
            [Caption("Tylko ostatni segment numeru")]
            [Soneta.Tools.Priority(2)]
            public bool TylkoOstatniSegmentNumeru {
                get { return tylkoOstatniSegmentNumeru; }
                set { tylkoOstatniSegmentNumeru = value; }
            }

            bool pokazInfoSkrocone = false;
            [Caption("Pokaż skrócone info")]
            [Soneta.Tools.Priority(3)]
            public bool PokazInfoSkrocone {
                get { return pokazInfoSkrocone; }
                set { pokazInfoSkrocone = value; }
            }

            bool ukrywajZera = false;
            [Caption("Ukrywaj wartości zerowe")]
            [Soneta.Tools.Priority(4)]
            public bool UkrywajZera {
                get { return ukrywajZera; }
                set { ukrywajZera = value; }
            }
        }
    }
}
